/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.work;

import com.google.common.collect.Iterables;
import java.util.concurrent.atomic.AtomicLong;
import org.gradle.api.Describable;
import org.gradle.internal.Factory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.internal.work.ResourceLockStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResourceLockStatistics
implements ResourceLockStatistics {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultResourceLockStatistics.class);
    private final AtomicLong totalBlockedTime = new AtomicLong(-1L);
    private final BuildOperationRunner buildOperationRunner;

    public DefaultResourceLockStatistics(BuildOperationRunner buildOperationRunner) {
        this.buildOperationRunner = buildOperationRunner;
    }

    @Override
    public void measureLockAcquisition(Iterable<? extends Describable> locks, Runnable runnable) {
        this.measure("Blocked on", locks, () -> {
            Timer timer = Time.startTimer();
            runnable.run();
            this.totalBlockedTime.addAndGet(timer.getElapsedMillis());
            return null;
        });
    }

    @Override
    public <T> T measure(final String operation, final Iterable<? extends Describable> locks, final Factory<T> factory) {
        return (T)this.buildOperationRunner.call(new CallableBuildOperation<T>(){

            public T call(BuildOperationContext context) {
                return factory.create();
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)(operation + " [" + String.join((CharSequence)", ", Iterables.transform((Iterable)locks, Describable::getDisplayName)) + "]"));
            }
        });
    }

    @Override
    public void complete() {
        LOGGER.warn("Time spent waiting on resource locks: {}ms", (Object)this.totalBlockedTime.get());
    }
}

