/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import org.gradle.util.internal.WrapperDistributionUrlConverter;
import org.gradle.wrapper.BootstrapMainStarter;
import org.gradle.wrapper.Install;
import org.gradle.wrapper.WrapperConfiguration;

public class WrapperExecutor {
    public static final String DISTRIBUTION_URL_PROPERTY = "distributionUrl";
    public static final String DISTRIBUTION_BASE_PROPERTY = "distributionBase";
    public static final String DISTRIBUTION_PATH_PROPERTY = "distributionPath";
    public static final String DISTRIBUTION_SHA_256_SUM = "distributionSha256Sum";
    public static final String ZIP_STORE_BASE_PROPERTY = "zipStoreBase";
    public static final String ZIP_STORE_PATH_PROPERTY = "zipStorePath";
    public static final String NETWORK_TIMEOUT_PROPERTY = "networkTimeout";
    public static final String VALIDATE_DISTRIBUTION_URL = "validateDistributionUrl";
    private final Properties properties;
    private final File propertiesFile;
    private final WrapperConfiguration config = new WrapperConfiguration();

    public static File wrapperPropertiesForProjectDirectory(File projectDir) {
        return new File(projectDir, "gradle/wrapper/gradle-wrapper.properties");
    }

    public static WrapperExecutor forProjectDirectory(File projectDir) {
        return new WrapperExecutor(WrapperExecutor.wrapperPropertiesForProjectDirectory(projectDir), new Properties());
    }

    public static WrapperExecutor forWrapperPropertiesFile(File propertiesFile) {
        if (!propertiesFile.exists()) {
            throw new RuntimeException(String.format("Wrapper properties file '%s' does not exist.", propertiesFile));
        }
        return new WrapperExecutor(propertiesFile, new Properties());
    }

    WrapperExecutor(File propertiesFile, Properties properties) {
        this.properties = properties;
        this.propertiesFile = propertiesFile;
        if (propertiesFile.exists()) {
            try {
                WrapperExecutor.loadProperties(propertiesFile, properties);
                this.config.setDistribution(WrapperDistributionUrlConverter.convertDistributionUrl(this.readDistroUrl(), propertiesFile.getParentFile()));
                this.config.setDistributionBase(this.getProperty(DISTRIBUTION_BASE_PROPERTY, this.config.getDistributionBase()));
                this.config.setDistributionPath(this.getProperty(DISTRIBUTION_PATH_PROPERTY, this.config.getDistributionPath()));
                this.config.setDistributionSha256Sum(this.getProperty(DISTRIBUTION_SHA_256_SUM, this.config.getDistributionSha256Sum(), false));
                this.config.setZipBase(this.getProperty(ZIP_STORE_BASE_PROPERTY, this.config.getZipBase()));
                this.config.setZipPath(this.getProperty(ZIP_STORE_PATH_PROPERTY, this.config.getZipPath()));
                this.config.setNetworkTimeout(this.getProperty(NETWORK_TIMEOUT_PROPERTY, this.config.getNetworkTimeout()));
                this.config.setValidateDistributionUrl(this.getProperty(VALIDATE_DISTRIBUTION_URL, this.config.getValidateDistributionUrl()));
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Could not load wrapper properties from '%s'.", propertiesFile), e);
            }
        }
    }

    private String readDistroUrl() {
        if (this.properties.getProperty(DISTRIBUTION_URL_PROPERTY) == null) {
            this.reportMissingProperty(DISTRIBUTION_URL_PROPERTY);
        }
        return this.getProperty(DISTRIBUTION_URL_PROPERTY);
    }

    private static void loadProperties(File propertiesFile, Properties properties) throws IOException {
        try (FileInputStream inStream = new FileInputStream(propertiesFile);){
            properties.load(inStream);
        }
    }

    public URI getDistribution() {
        return this.config.getDistribution();
    }

    public WrapperConfiguration getConfiguration() {
        return this.config;
    }

    public void execute(String[] args, Install install, BootstrapMainStarter bootstrapMainStarter) throws Exception {
        File gradleHome = install.createDist(this.config);
        bootstrapMainStarter.start(args, gradleHome);
    }

    private String getProperty(String propertyName) {
        return this.getProperty(propertyName, null, true);
    }

    private String getProperty(String propertyName, String defaultValue) {
        return this.getProperty(propertyName, defaultValue, true);
    }

    private int getProperty(String propertyName, int defaultValue) {
        return Integer.parseInt(this.getProperty(propertyName, String.valueOf(defaultValue)));
    }

    private boolean getProperty(String propertyName, boolean defaultValue) {
        return Boolean.parseBoolean(this.getProperty(propertyName, String.valueOf(defaultValue)));
    }

    private String getProperty(String propertyName, String defaultValue, boolean required) {
        String value = this.properties.getProperty(propertyName);
        if (value != null) {
            return value;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        if (required) {
            return this.reportMissingProperty(propertyName);
        }
        return null;
    }

    private String reportMissingProperty(String propertyName) {
        throw new RuntimeException(String.format("No value with key '%s' specified in wrapper properties file '%s'.", propertyName, this.propertiesFile));
    }
}

