/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.DelegatingDomainObjectSet;
import org.gradle.api.internal.DomainObjectCollectionInternal;
import org.gradle.api.internal.InternalAction;
import org.gradle.api.internal.MutationGuard;
import org.gradle.api.internal.MutationGuards;
import org.gradle.api.internal.collections.ElementSource;
import org.gradle.api.internal.collections.EventSubscriptionVerifier;
import org.gradle.api.internal.provider.CollectionProviderInternal;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Actions;
import org.jspecify.annotations.Nullable;

public class CompositeDomainObjectSet<T>
extends DelegatingDomainObjectSet<T> {
    private final Spec<T> uniqueSpec = new ItemIsUniqueInCompositeSpec();
    private final Spec<T> notInSpec = new ItemNotInCompositeSpec();
    private final CollectionCallbackActionDecorator callbackActionDecorator;

    @SafeVarargs
    public static <T> CompositeDomainObjectSet<T> create(Class<T> type, DomainObjectCollection<? extends T> ... collections) {
        return CompositeDomainObjectSet.create(type, CollectionCallbackActionDecorator.NOOP, collections);
    }

    @SafeVarargs
    public static <T> CompositeDomainObjectSet<T> create(Class<T> type, CollectionCallbackActionDecorator callbackActionDecorator, DomainObjectCollection<? extends T> ... collections) {
        DefaultDomainObjectSet<T> delegate = new DefaultDomainObjectSet<T>(type, new DomainObjectCompositeCollection(), callbackActionDecorator);
        CompositeDomainObjectSet<? extends T> out = new CompositeDomainObjectSet<T>(delegate, callbackActionDecorator);
        for (DomainObjectCollection<? extends T> c : collections) {
            out.addCollection(c);
        }
        return out;
    }

    private CompositeDomainObjectSet(DefaultDomainObjectSet<T> delegate, CollectionCallbackActionDecorator callbackActionDecorator) {
        super(delegate);
        this.callbackActionDecorator = callbackActionDecorator;
    }

    @Override
    protected DefaultDomainObjectSet<T> getDelegate() {
        return (DefaultDomainObjectSet)super.getDelegate();
    }

    protected DomainObjectCompositeCollection<T> getStore() {
        return (DomainObjectCompositeCollection)this.getDelegate().getStore();
    }

    @Override
    public Action<? super T> whenObjectAdded(Action<? super T> action) {
        return super.whenObjectAdded(Actions.filter(action, this.uniqueSpec));
    }

    @Override
    public Action<? super T> whenObjectRemoved(Action<? super T> action) {
        return super.whenObjectRemoved(Actions.filter(action, this.notInSpec));
    }

    public void addCollection(DomainObjectCollection<? extends T> collection) {
        if (!this.getStore().containsCollection(collection)) {
            this.getStore().addComposited((DomainObjectCollectionInternal)collection);
            collection.all((Action)((InternalAction)t -> this.getDelegate().getEventRegister().fireObjectAdded(t)));
            collection.whenObjectRemoved(t -> this.getDelegate().getEventRegister().fireObjectRemoved(t));
        }
    }

    public void addCollectionProvider(Provider<DomainObjectCollection<? extends T>> collectionProvider) {
        if (!this.getStore().containsCollectionProvider(collectionProvider)) {
            this.getStore().addComposited(collectionProvider, collection -> {
                collection.all((Action)((InternalAction)t -> this.getDelegate().getEventRegister().fireObjectAdded(t)));
                collection.whenObjectRemoved(t -> this.getDelegate().getEventRegister().fireObjectRemoved(t));
            });
        }
    }

    public void removeCollection(DomainObjectCollection<? extends T> collection) {
        this.getStore().removeComposited(collection);
        for (Object item : collection) {
            this.getDelegate().getEventRegister().fireObjectRemoved(item);
        }
    }

    public void removeCollectionProvider(Provider<DomainObjectCollection<? extends T>> collectionProvider) {
        this.getStore().removeComposited(collectionProvider, collection -> {
            for (Object item : collection) {
                this.getDelegate().getEventRegister().fireObjectRemoved(item);
            }
        });
    }

    @Override
    public Iterator<T> iterator() {
        return this.getStore().iterator();
    }

    @Override
    public int size() {
        return this.getStore().size();
    }

    @Override
    public int estimatedSize() {
        return this.getStore().estimatedSize();
    }

    @Override
    public void all(Action<? super T> action) {
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            T t = iterator.next();
            this.callbackActionDecorator.decorate(action).execute(t);
        }
        this.whenObjectAdded(action);
    }

    private static final class DomainObjectCompositeCollection<T>
    implements ElementSource<T> {
        private final List<StoredCollection<T>> store = new LinkedList<StoredCollection<T>>();

        private DomainObjectCompositeCollection() {
        }

        public boolean containsCollection(DomainObjectCollection<? extends T> collection) {
            return this.store.stream().filter(it -> it instanceof RealizedCollection).map(StoredCollection::get).anyMatch(stored -> stored == collection);
        }

        public boolean containsCollectionProvider(Provider<?> collectionProvider) {
            return this.store.stream().filter(it -> it instanceof ProvidedCollection).map(it -> ((ProvidedCollection)it).getProvider()).anyMatch(stored -> stored == collectionProvider);
        }

        Set<T> collect() {
            if (this.store.isEmpty()) {
                return Collections.emptySet();
            }
            LinkedHashSet tmp = Sets.newLinkedHashSetWithExpectedSize((int)this.estimatedSize());
            for (StoredCollection<T> collection : this.store) {
                tmp.addAll(collection.get());
            }
            return tmp;
        }

        @Override
        public int size() {
            return this.collect().size();
        }

        @Override
        public boolean isEmpty() {
            return this.store.stream().allMatch(it -> it.get().isEmpty());
        }

        @Override
        public boolean contains(Object o) {
            return this.store.stream().anyMatch(it -> it.get().contains(o));
        }

        @Override
        public Iterator<T> iterator() {
            if (this.store.isEmpty()) {
                return Collections.emptyIterator();
            }
            if (this.store.size() == 1) {
                return this.store.get(0).get().iterator();
            }
            return this.collect().iterator();
        }

        @Override
        public boolean add(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        public void addComposited(DomainObjectCollectionInternal<? extends T> collection) {
            this.store.add(new RealizedCollection<T>(collection));
        }

        public void addComposited(Provider<DomainObjectCollection<? extends T>> collectionProvider, Action<DomainObjectCollection<? extends T>> onRealization) {
            this.store.add(new ProvidedCollection<T>(collectionProvider, onRealization));
        }

        public void removeComposited(DomainObjectCollection<? extends T> collection) {
            Iterator<StoredCollection<T>> iterator = this.store.iterator();
            while (iterator.hasNext()) {
                StoredCollection<T> next = iterator.next();
                if (!(next instanceof RealizedCollection) || next.get() != collection) continue;
                iterator.remove();
                break;
            }
        }

        public void removeComposited(Provider<DomainObjectCollection<? extends T>> collectionProvider, Action<DomainObjectCollection<? extends T>> onRealized) {
            Iterator<StoredCollection<T>> iterator = this.store.iterator();
            while (iterator.hasNext()) {
                ProvidedCollection provided;
                StoredCollection<T> next = iterator.next();
                if (!(next instanceof ProvidedCollection) || (provided = (ProvidedCollection)next).getProvider() != collectionProvider) continue;
                iterator.remove();
                if (!provided.realized) break;
                onRealized.execute((Object)((DomainObjectCollection)provided.getProvider().get()));
                break;
            }
        }

        @Override
        public boolean constantTimeIsEmpty() {
            return this.store.isEmpty();
        }

        @Override
        public int estimatedSize() {
            return this.store.stream().mapToInt(stored -> ((DomainObjectCollectionInternal)stored.getWithoutSideEffects()).estimatedSize()).sum();
        }

        @Override
        public Iterator<T> iteratorNoFlush() {
            return this.iterator();
        }

        @Override
        public void realizePending() {
        }

        @Override
        public void realizePending(Class<?> type) {
        }

        @Override
        public boolean addPending(ProviderInternal<? extends T> provider) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removePending(ProviderInternal<? extends T> provider) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addPendingCollection(CollectionProviderInternal<T, ? extends Iterable<T>> provider) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removePendingCollection(CollectionProviderInternal<T, ? extends Iterable<T>> provider) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void onPendingAdded(Action<T> action) {
        }

        @Override
        public void setSubscriptionVerifier(EventSubscriptionVerifier<T> immediateRealizationSpec) {
        }

        @Override
        public void realizeExternal(ProviderInternal<? extends T> provider) {
        }

        @Override
        public MutationGuard getLazyBehaviorGuard() {
            return MutationGuards.identity();
        }

        static interface StoredCollection<T> {
            public DomainObjectCollection<? extends T> get();

            public DomainObjectCollection<? extends T> getWithoutSideEffects();
        }

        static class RealizedCollection<T>
        implements StoredCollection<T> {
            private final DomainObjectCollection<? extends T> collection;

            RealizedCollection(DomainObjectCollection<? extends T> collection) {
                this.collection = collection;
            }

            @Override
            public DomainObjectCollection<? extends T> get() {
                return this.collection;
            }

            @Override
            public DomainObjectCollection<? extends T> getWithoutSideEffects() {
                return this.collection;
            }
        }

        static class ProvidedCollection<T>
        implements StoredCollection<T> {
            private final Provider<DomainObjectCollection<? extends T>> provider;
            private final Action<DomainObjectCollection<? extends T>> onRealization;
            private boolean realized;
            private @Nullable DomainObjectCollection<? extends T> collection = null;

            ProvidedCollection(Provider<DomainObjectCollection<? extends T>> provider, Action<DomainObjectCollection<? extends T>> onRealization) {
                this.provider = provider;
                this.onRealization = onRealization;
            }

            @Override
            public DomainObjectCollection<? extends T> get() {
                if (this.collection == null) {
                    this.collection = (DomainObjectCollection)this.provider.get();
                }
                if (!this.realized) {
                    this.onRealization.execute(this.collection);
                    this.realized = true;
                }
                return this.collection;
            }

            @Override
            public DomainObjectCollection<? extends T> getWithoutSideEffects() {
                if (this.collection == null) {
                    this.collection = (DomainObjectCollection)this.provider.get();
                }
                return this.collection;
            }

            public Provider<DomainObjectCollection<? extends T>> getProvider() {
                return this.provider;
            }
        }
    }

    public class ItemIsUniqueInCompositeSpec
    implements Spec<T> {
        public boolean isSatisfiedBy(T element) {
            int matches = 0;
            for (DomainObjectCompositeCollection.StoredCollection stored : CompositeDomainObjectSet.this.getStore().store) {
                if (!stored.getWithoutSideEffects().contains(element) || ++matches <= 1) continue;
                return false;
            }
            return true;
        }
    }

    public class ItemNotInCompositeSpec
    implements Spec<T> {
        public boolean isSatisfiedBy(T element) {
            return !CompositeDomainObjectSet.this.getStore().contains(element);
        }
    }
}

