/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.gradle.execution.EntryTaskSelector;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.jspecify.annotations.Nullable;

@ServiceScope(value={Scope.BuildTree.class})
public interface BuildTreeWorkController {
    public TaskRunResult scheduleAndRunRequestedTasks(@Nullable EntryTaskSelector var1);

    public static class TaskRunResult {
        private final ExecutionResult<Void> scheduleResult;
        private final @Nullable ExecutionResult<Void> executionResult;

        private TaskRunResult(ExecutionResult<Void> scheduleResult, @Nullable ExecutionResult<Void> executionResult) {
            this.scheduleResult = scheduleResult;
            this.executionResult = executionResult;
        }

        public ExecutionResult<Void> getScheduleResult() {
            return this.scheduleResult;
        }

        public ExecutionResult<Void> getExecutionResultOrThrow() {
            this.scheduleResult.rethrow();
            return (ExecutionResult)Preconditions.checkNotNull(this.executionResult);
        }

        public Optional<ExecutionResult<Void>> getExecutionResult() {
            return Optional.ofNullable(this.executionResult);
        }

        public static TaskRunResult ofExecutionResult(ExecutionResult<Void> executionResult) {
            return new TaskRunResult(ExecutionResult.succeeded(), executionResult);
        }

        public static TaskRunResult ofScheduleFailure(Throwable scheduleResult) {
            return new TaskRunResult(ExecutionResult.failed(scheduleResult), null);
        }
    }
}

