/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirInlineDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirInlineBodyResolvableExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;)V", "InlinableParameterContext", "checkers"})
public final class FirInlineBodyResolvableExpressionChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirInlineBodyResolvableExpressionChecker INSTANCE = new FirInlineBodyResolvableExpressionChecker();

    private FirInlineBodyResolvableExpressionChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirStatement expression2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        InlinableParameterContext inlinableParameterContext = context2.getInlinableParameterContext();
        if (inlinableParameterContext == null) {
            return;
        }
        InlinableParameterContext inlinableParameterContext2 = inlinableParameterContext;
        FirInlineDeclarationChecker.InlineFunctionBodyContext inlineFunctionBodyContext = context2.getInlineFunctionBodyContext();
        if (!(expression2 instanceof FirQualifiedAccessExpression) && !(expression2 instanceof FirDelegatedConstructorCall)) {
            return;
        }
        FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol((FirResolvable)((Object)expression2));
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol<?> targetSymbol = firCallableSymbol;
        FirInlineDeclarationChecker.InlineFunctionBodyContext inlineFunctionBodyContext2 = inlineFunctionBodyContext;
        if (inlineFunctionBodyContext2 != null) {
            inlineFunctionBodyContext2.check(context2, reporter, expression2, targetSymbol);
        }
        inlinableParameterContext2.check(context2, reporter, expression2, targetSymbol);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ7\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014R\u00020\rR\u00020\u000fj\u0006\u0010\u000e\u001a\u00020\rj\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0015JC\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0002R\u00020\rR\u00020\u000fj\u0006\u0010\u000e\u001a\u00020\rj\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u001cJ\u0019\u0010\u001d\u001a\u00020\u001eH\u0002R\u00020\rj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u001fJ/\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#\u0018\u00010!2\u0006\u0010$\u001a\u00020%H\u0002R\u00020\rj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u00020\u001e*\u0006\u0012\u0002\b\u00030(H\u0002J9\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020+2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0002R\u00020\rR\u00020\u000fj\u0006\u0010\u000e\u001a\u00020\rj\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010,J\u0010\u0010-\u001a\u00020\u001e*\u0006\u0012\u0002\b\u00030\u001bH\u0002J\u001d\u0010.\u001a\u00020\u001e*\u00020\u0012H\u0002R\u00020\rj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010/R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirInlineBodyResolvableExpressionChecker$InlinableParameterContext;", "", "inlineFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "inlinableParameters", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Ljava/util/List;Lorg/jetbrains/kotlin/fir/FirSession;)V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "statement", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "targetSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)V", "checkReceiver", "qualifiedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "receiverExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)V", "isNonLocalReturnAllowed", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Z", "extractCallAndParameter", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "anonymousFunction", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirAnonymousFunctionSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirAnonymousFunctionSymbol;)Lkotlin/Pair;", "isArrayLambdaConstructor", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "checkArgumentsOfCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirCall;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirCall;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)V", "isInvokeOfSomeFunctionType", "partOfCall", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;)Z", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirInlineBodyResolvableExpressionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirInlineBodyResolvableExpressionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirInlineBodyResolvableExpressionChecker$InlinableParameterContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,201:1\n1807#2,3:202\n296#2,2:214\n1807#2,3:218\n32#3:205\n32#3:216\n71#4,4:206\n71#4,4:210\n57#4:217\n*S KotlinDebug\n*F\n+ 1 FirInlineBodyResolvableExpressionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirInlineBodyResolvableExpressionChecker$InlinableParameterContext\n*L\n49#1:202,3\n159#1:214,2\n193#1:218,3\n112#1:205\n162#1:216\n123#1:206,4\n154#1:210,4\n193#1:217\n*E\n"})
    public static final class InlinableParameterContext {
        @NotNull
        private final FirFunction inlineFunction;
        @NotNull
        private final List<FirValueParameterSymbol> inlinableParameters;
        @NotNull
        private final FirSession session;

        public InlinableParameterContext(@NotNull FirFunction inlineFunction, @NotNull List<FirValueParameterSymbol> inlinableParameters, @NotNull FirSession session) {
            Intrinsics.checkNotNullParameter((Object)inlineFunction, (String)"inlineFunction");
            Intrinsics.checkNotNullParameter(inlinableParameters, (String)"inlinableParameters");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.inlineFunction = inlineFunction;
            this.inlinableParameters = inlinableParameters;
            this.session = session;
        }

        public final void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirStatement statement, @NotNull FirCallableSymbol<?> targetSymbol) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            Intrinsics.checkNotNullParameter(targetSymbol, (String)"targetSymbol");
            KtSourceElement ktSourceElement = statement.getSource();
            if (ktSourceElement == null) {
                return;
            }
            KtSourceElement source = ktSourceElement;
            if (CollectionsKt.contains((Iterable)this.inlinableParameters, targetSymbol)) {
                boolean bl;
                block9: {
                    if (!this.partOfCall(context2, statement)) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE(), targetSymbol, null, 16, null);
                    }
                    Iterable $this$any$iv = context2.getContainingDeclarations();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            FirBasedSymbol it = (FirBasedSymbol)element$iv;
                            boolean bl2 = false;
                            if (!CollectionsKt.contains((Iterable)this.inlinableParameters, (Object)it)) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNOT_SUPPORTED_INLINE_PARAMETER_IN_INLINE_PARAMETER_DEFAULT_VALUE(), (Object)((FirValueParameterSymbol)targetSymbol), null, 16, null);
                }
            }
            if (statement instanceof FirQualifiedAccessExpression) {
                this.checkReceiver(context2, reporter, (FirQualifiedAccessExpression)statement, ((FirQualifiedAccessExpression)statement).getDispatchReceiver(), (FirBasedSymbol)targetSymbol);
                this.checkReceiver(context2, reporter, (FirQualifiedAccessExpression)statement, ((FirQualifiedAccessExpression)statement).getExtensionReceiver(), (FirBasedSymbol)targetSymbol);
            }
            if (statement instanceof FirCall) {
                this.checkArgumentsOfCall(context2, reporter, (FirCall)statement, (FirBasedSymbol)targetSymbol);
            }
        }

        private final void checkReceiver(CheckerContext context2, DiagnosticReporter reporter, FirQualifiedAccessExpression qualifiedAccessExpression, FirExpression receiverExpression, FirBasedSymbol<?> targetSymbol) {
            if (receiverExpression == null) {
                return;
            }
            FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(FirExpressionUtilKt.unwrapErrorExpression(receiverExpression), this.session);
            FirValueParameterSymbol firValueParameterSymbol = firCallableSymbol instanceof FirValueParameterSymbol ? (FirValueParameterSymbol)firCallableSymbol : null;
            if (firValueParameterSymbol == null) {
                return;
            }
            FirValueParameterSymbol receiverSymbol = firValueParameterSymbol;
            if (this.inlinableParameters.contains(receiverSymbol)) {
                if (!this.isInvokeOfSomeFunctionType(targetSymbol) || qualifiedAccessExpression instanceof FirCallableReferenceAccess) {
                    DiagnosticContext diagnosticContext2 = context2;
                    KtSourceElement ktSourceElement = receiverExpression.getSource();
                    if (ktSourceElement == null) {
                        ktSourceElement = qualifiedAccessExpression.getSource();
                    }
                    KtDiagnosticReportHelpersKt.reportOn$default(diagnosticContext2, reporter, (AbstractKtSourceElement)ktSourceElement, FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE(), (Object)receiverSymbol, null, 16, null);
                } else if (!receiverSymbol.isCrossinline() && !this.isNonLocalReturnAllowed(context2)) {
                    DiagnosticContext diagnosticContext3 = context2;
                    KtSourceElement ktSourceElement = receiverExpression.getSource();
                    if (ktSourceElement == null) {
                        ktSourceElement = qualifiedAccessExpression.getSource();
                    }
                    KtDiagnosticReportHelpersKt.reportOn$default(diagnosticContext3, reporter, (AbstractKtSourceElement)ktSourceElement, FirErrors.INSTANCE.getNON_LOCAL_RETURN_NOT_ALLOWED(), (Object)receiverSymbol, null, 16, null);
                }
            }
        }

        private final boolean isNonLocalReturnAllowed(CheckerContext context2) {
            List<FirBasedSymbol<?>> declarations2 = context2.getContainingDeclarations();
            int inlineFunctionIndex = declarations2.indexOf(this.inlineFunction.getSymbol());
            if (inlineFunctionIndex == -1) {
                return true;
            }
            int n2 = declarations2.size();
            for (int i2 = inlineFunctionIndex + 1; i2 < n2; ++i2) {
                FirFunctionSymbol callable;
                Pair<FirFunctionCall, FirValueParameter> pair;
                FirBasedSymbol<?> declaration = declarations2.get(i2);
                if (!(declaration instanceof FirFunctionSymbol) && !(declaration instanceof FirClassSymbol)) continue;
                FirAnonymousFunctionSymbol firAnonymousFunctionSymbol = declaration instanceof FirAnonymousFunctionSymbol ? (FirAnonymousFunctionSymbol)declaration : null;
                if (firAnonymousFunctionSymbol == null) {
                    return false;
                }
                FirAnonymousFunctionSymbol anonymousFunction = firAnonymousFunctionSymbol;
                if (this.extractCallAndParameter(context2, anonymousFunction) == null) {
                    return false;
                }
                FirFunctionCall call2 = (FirFunctionCall)pair.component1();
                FirValueParameter parameter = (FirValueParameter)pair.component2();
                FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(call2);
                if ((firCallableSymbol instanceof FirFunctionSymbol ? (FirFunctionSymbol)firCallableSymbol : null) == null) {
                    return false;
                }
                callable = callable;
                FirCallableSymbol $this$isInline$iv = callable;
                boolean $i$f$isInline = false;
                if (!$this$isInline$iv.getRawStatus().isInline() && !this.isArrayLambdaConstructor(callable)) {
                    return false;
                }
                if (!parameter.isNoinline() && !parameter.isCrossinline()) continue;
                return false;
            }
            return true;
        }

        private final Pair<FirFunctionCall, FirValueParameter> extractCallAndParameter(CheckerContext context2, FirAnonymousFunctionSymbol anonymousFunction) {
            for (FirStatement call2 : context2.getCallsOrAssignments()) {
                LinkedHashMap<FirExpression, FirValueParameter> mapping;
                if (!(call2 instanceof FirFunctionCall)) continue;
                FirCall $this$resolvedArgumentMapping$iv = (FirCall)call2;
                boolean $i$f$getResolvedArgumentMapping = false;
                FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
                if ((argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null) == null) continue;
                mapping = mapping;
                for (Map.Entry entry : ((Map)mapping).entrySet()) {
                    FirExpression argument = (FirExpression)entry.getKey();
                    FirValueParameter parameter = (FirValueParameter)entry.getValue();
                    FirExpression firExpression = FirExpressionUtilKt.unwrapArgument(argument);
                    FirPureAbstractElement firPureAbstractElement = firExpression instanceof FirAnonymousFunctionExpression ? (FirAnonymousFunctionExpression)firExpression : null;
                    if ((firPureAbstractElement != null && (firPureAbstractElement = ((FirAnonymousFunctionExpression)firPureAbstractElement).getAnonymousFunction()) != null ? ((FirAnonymousFunction)firPureAbstractElement).getSymbol() : null) != anonymousFunction) continue;
                    return TuplesKt.to((Object)call2, (Object)parameter);
                }
            }
            return null;
        }

        private final boolean isArrayLambdaConstructor(FirFunctionSymbol<?> $this$isArrayLambdaConstructor) {
            return $this$isArrayLambdaConstructor instanceof FirConstructorSymbol && ((FirConstructorSymbol)$this$isArrayLambdaConstructor).getValueParameterSymbols().size() == 2 && ArrayUtilsKt.isArrayOrPrimitiveArray(((FirConstructorSymbol)$this$isArrayLambdaConstructor).getResolvedReturnType());
        }

        private final void checkArgumentsOfCall(CheckerContext context2, DiagnosticReporter reporter, FirCall functionCall, FirBasedSymbol<?> targetSymbol) {
            if (context2.isContractBody()) {
                return;
            }
            FirFunctionSymbol firFunctionSymbol = targetSymbol instanceof FirFunctionSymbol ? (FirFunctionSymbol)targetSymbol : null;
            if (firFunctionSymbol == null) {
                return;
            }
            FirFunctionSymbol calledFunctionSymbol = firFunctionSymbol;
            FirCall $this$resolvedArgumentMapping$iv = functionCall;
            boolean $i$f$getResolvedArgumentMapping = false;
            FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
            LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
            if (linkedHashMap == null) {
                return;
            }
            LinkedHashMap<FirExpression, FirValueParameter> argumentMapping2 = linkedHashMap;
            for (Map.Entry entry : ((Map)argumentMapping2).entrySet()) {
                KtDiagnosticFactory1<FirBasedSymbol<?>> ktDiagnosticFactory1;
                FirValueParameterSymbol valueParameterOfOriginalInlineFunction;
                Object v2;
                FirExpression argument;
                FirValueParameter valueParameter2;
                block9: {
                    FirVariableSymbol resolvedArgumentSymbol;
                    FirExpression wrappedArgument = (FirExpression)entry.getKey();
                    valueParameter2 = (FirValueParameter)entry.getValue();
                    argument = FirExpressionUtilKt.unwrapArgument(FirExpressionUtilKt.unwrapErrorExpression(wrappedArgument));
                    FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(argument, this.session);
                    if ((firCallableSymbol instanceof FirVariableSymbol ? (FirVariableSymbol)firCallableSymbol : null) == null) continue;
                    resolvedArgumentSymbol = resolvedArgumentSymbol;
                    Iterable $this$firstOrNull$iv = this.inlinableParameters;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)resolvedArgumentSymbol)) continue;
                        v2 = element$iv;
                        break block9;
                    }
                    v2 = null;
                }
                if ((valueParameterOfOriginalInlineFunction = (FirValueParameterSymbol)v2) == null) continue;
                FirCallableSymbol $this$isInline$iv = calledFunctionSymbol;
                boolean $i$f$isInline = false;
                if ($this$isInline$iv.getRawStatus().isInline()) {
                    if (!DeclarationUtilsKt.isInlinable(valueParameter2, this.session)) {
                        ktDiagnosticFactory1 = FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE();
                    } else {
                        if (valueParameterOfOriginalInlineFunction.isCrossinline() || !valueParameter2.isCrossinline() && this.isNonLocalReturnAllowed(context2)) continue;
                        ktDiagnosticFactory1 = FirErrors.INSTANCE.getNON_LOCAL_RETURN_NOT_ALLOWED();
                    }
                } else {
                    ktDiagnosticFactory1 = FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE();
                }
                KtDiagnosticFactory1<FirBasedSymbol<?>> factory = ktDiagnosticFactory1;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)argument.getSource(), factory, (Object)valueParameterOfOriginalInlineFunction, null, 16, null);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isInvokeOfSomeFunctionType(FirBasedSymbol<?> $this$isInvokeOfSomeFunctionType) {
            if (!($this$isInvokeOfSomeFunctionType instanceof FirNamedFunctionSymbol)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)((FirNamedFunctionSymbol)$this$isInvokeOfSomeFunctionType).getName(), (Object)OperatorNameConventions.INVOKE)) return false;
            ConeSimpleKotlinType coneSimpleKotlinType = ((FirNamedFunctionSymbol)$this$isInvokeOfSomeFunctionType).getDispatchReceiverType();
            if (coneSimpleKotlinType == null) return false;
            if (!FunctionalTypeUtilsKt.isSomeFunctionType(coneSimpleKotlinType, this.session)) return false;
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean partOfCall(CheckerContext context2, FirStatement $this$partOfCall) {
            boolean bl;
            block7: {
                void $this$any$iv;
                if (!($this$partOfCall instanceof FirExpression)) {
                    return false;
                }
                FirStatement firStatement = (FirStatement)CollectionsKt.getOrNull(context2.getCallsOrAssignments(), (int)(context2.getCallsOrAssignments().size() - 2));
                if (firStatement == null) {
                    return false;
                }
                FirStatement containingQualifiedAccess = firStatement;
                FirExpression firExpression = containingQualifiedAccess instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)containingQualifiedAccess : null;
                if (Intrinsics.areEqual((Object)$this$partOfCall, firExpression != null && (firExpression = firExpression.getExplicitReceiver()) != null ? FirExpressionUtilKt.unwrapErrorExpression(firExpression) : null)) {
                    return true;
                }
                FirCall firCall = containingQualifiedAccess instanceof FirCall ? (FirCall)containingQualifiedAccess : null;
                if (firCall == null) {
                    return false;
                }
                FirCall call2 = firCall;
                Object $this$arguments$iv = call2;
                boolean $i$f$getArguments = false;
                $this$arguments$iv = $this$arguments$iv.getArgumentList().getArguments();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirExpression it = (FirExpression)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)FirExpressionUtilKt.unwrapArgument(FirExpressionUtilKt.unwrapErrorExpression(it)), (Object)$this$partOfCall)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            return bl;
        }
    }
}

