/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import org.jetbrains.kotlin.fir.resolve.ContainingClassUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionOverrideFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0002\u0019\u001aB\u0011\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J-\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u00020\nR\u00020\fj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u0015\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001f\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u0002H\u0002R\u00020\nj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0018\u0082\u0001\u0002\u001b\u001c\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "mppKind", "Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;)V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "isBuiltinFunctionalTypeOrSubtype", "", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isSuspendFunctionTypeOrSubtype", "findFakeMethodOverridingExternalWithOptionalParams", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "Regular", "ForExpectClass", "Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker$Regular;", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsInheritanceClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsInheritanceClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n832#2:110\n862#2,2:111\n1642#2,10:113\n1915#2:123\n1916#2:125\n1652#2:126\n1807#2,3:127\n1807#2,3:130\n812#2,12:134\n777#2:146\n873#2,2:147\n296#2,2:149\n1#3:124\n1#3:133\n*S KotlinDebug\n*F\n+ 1 FirJsInheritanceClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker\n*L\n56#1:110\n56#1:111,2\n57#1:113,10\n57#1:123\n57#1:125\n57#1:126\n59#1:127,3\n77#1:130,3\n98#1:134,12\n99#1:146\n99#1:147,2\n104#1:149,2\n57#1:124\n*E\n"})
public abstract class FirJsInheritanceClassChecker
extends FirDeclarationChecker<FirClass> {
    private FirJsInheritanceClassChecker(MppCheckerKind mppKind) {
        super(mppKind);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
        FirNamedFunctionSymbol fakeOverriddenMethod;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        FirSession session = context2.getSession();
        boolean isEffectivelyExternal = FirWebCommonHelpersKt.isEffectivelyExternal((FirBasedSymbol)declaration.getSymbol(), session);
        if (isEffectivelyExternal && declaration.getClassKind() != ClassKind.ANNOTATION_CLASS) {
            boolean bl;
            block13: {
                Iterator $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                void $this$filterNotTo$iv$iv;
                Iterable $this$filterNot$iv;
                Iterable iterable = FirDeclarationUtilKt.getSuperConeTypes(declaration);
                boolean $i$f$filterNot = false;
                void var9_10 = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    ConeClassLikeType it = (ConeClassLikeType)element$iv$iv;
                    boolean bl2 = false;
                    if (ConeBuiltinTypeUtilsKt.isAnyOrNullableAny(it) || ConeBuiltinTypeUtilsKt.isThrowableOrNullableThrowable(it) || ConeBuiltinTypeUtilsKt.isEnum(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterNot$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$filterNotTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    FirRegularClassSymbol it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl3 = false;
                    ConeClassLikeType it = (ConeClassLikeType)element$iv$iv;
                    boolean bl4 = false;
                    FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toSymbol((SessionHolder)context2, it);
                    if ((firClassLikeSymbol != null ? DeclarationUtilsKt.fullyExpandedClass(context2, firClassLikeSymbol) : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List superTypes = (List)destination$iv$iv;
                Iterable $this$any$iv = superTypes;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirRegularClassSymbol it = (FirRegularClassSymbol)element$iv;
                        boolean bl6 = false;
                        if (!(!FirWebCommonHelpersKt.isEffectivelyExternal(it, session))) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getEXTERNAL_TYPE_EXTENDS_NON_EXTERNAL_TYPE(), null, 8, null);
            }
        }
        if (!isEffectivelyExternal && (fakeOverriddenMethod = this.findFakeMethodOverridingExternalWithOptionalParams(context2, declaration)) != null) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getOVERRIDING_EXTERNAL_FUN_WITH_OPTIONAL_PARAMS_WITH_FAKE(), (Object)fakeOverriddenMethod, null, 16, null);
        }
        if (!LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.JsAllowImplementingFunctionInterface)) {
            boolean bl;
            block14: {
                Iterable $this$any$iv = FirDeclarationUtilKt.getSuperConeTypes(declaration);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ConeClassLikeType it = (ConeClassLikeType)element$iv;
                        boolean bl7 = false;
                        if (!(this.isBuiltinFunctionalTypeOrSubtype(it, session) && !this.isSuspendFunctionTypeOrSubtype(it, session))) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getIMPLEMENTING_FUNCTION_INTERFACE(), null, 8, null);
            }
        }
    }

    private final boolean isBuiltinFunctionalTypeOrSubtype(ConeClassLikeType $this$isBuiltinFunctionalTypeOrSubtype, FirSession session) {
        ConeInferenceContext $this$isBuiltinFunctionalTypeOrSubtype_u24lambda_u240 = TypeComponentsKt.getTypeContext(session);
        boolean bl = false;
        return $this$isBuiltinFunctionalTypeOrSubtype_u24lambda_u240.isBuiltinFunctionTypeOrSubtype($this$isBuiltinFunctionalTypeOrSubtype);
    }

    private final boolean isSuspendFunctionTypeOrSubtype(ConeClassLikeType $this$isSuspendFunctionTypeOrSubtype, FirSession session) {
        ConeInferenceContext $this$isSuspendFunctionTypeOrSubtype_u24lambda_u240 = TypeComponentsKt.getTypeContext(session);
        boolean bl = false;
        return $this$isSuspendFunctionTypeOrSubtype_u24lambda_u240.isTypeOrSubtypeOf($this$isSuspendFunctionTypeOrSubtype, (Function1<? super ConeKotlinType, Boolean>)((Function1)arg_0 -> FirJsInheritanceClassChecker.isSuspendFunctionTypeOrSubtype$lambda$0$0(session, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private final FirNamedFunctionSymbol findFakeMethodOverridingExternalWithOptionalParams(CheckerContext context2, FirClass $this$findFakeMethodOverridingExternalWithOptionalParams) {
        Object v0;
        block3: {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            FirTypeScope scope2 = FirHelpersKt.unsubstitutedScope(context2, $this$findFakeMethodOverridingExternalWithOptionalParams.getSymbol());
            Iterable iterable = FirContainingNamesAwareScopeKt.collectAllFunctions(scope2);
            boolean $i$f$filterIsInstance = false;
            Iterator iterator2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FirIntersectionOverrideFunctionSymbol)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FirIntersectionOverrideFunctionSymbol it = (FirIntersectionOverrideFunctionSymbol)element$iv$iv;
                boolean bl = false;
                FirClassLikeSymbol<?> container = ContainingClassUtilsKt.getContainingClassSymbol(it);
                if (!(Intrinsics.areEqual(container, $this$findFakeMethodOverridingExternalWithOptionalParams.getSymbol()) && !it.getIntersections().isEmpty())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List members = (List)destination$iv$iv;
            Iterable $this$firstOrNull$iv = members;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirIntersectionOverrideFunctionSymbol it = (FirIntersectionOverrideFunctionSymbol)element$iv;
                boolean bl = false;
                if (!FirJsHelpersKt.isOverridingExternalWithOptionalParams(context2, it)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        return v0;
    }

    private static final boolean isSuspendFunctionTypeOrSubtype$lambda$0$0(FirSession $session, ConeKotlinType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FunctionalTypeUtilsKt.isSuspendOrKSuspendFunctionType(it, $session);
    }

    public /* synthetic */ FirJsInheritanceClassChecker(MppCheckerKind mppKind, DefaultConstructorMarker $constructor_marker) {
        this(mppKind);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "checkers.js"})
    @SourceDebugExtension(value={"SMAP\nFirJsInheritanceClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsInheritanceClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker$ForExpectClass\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,109:1\n35#2:110\n*S KotlinDebug\n*F\n+ 1 FirJsInheritanceClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker$ForExpectClass\n*L\n44#1:110\n*E\n"})
    public static final class ForExpectClass
    extends FirJsInheritanceClassChecker {
        @NotNull
        public static final ForExpectClass INSTANCE = new ForExpectClass();

        private ForExpectClass() {
            super(MppCheckerKind.Common, null);
        }

        @Override
        public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            FirMemberDeclaration $this$isExpect$iv = declaration;
            boolean $i$f$isExpect = false;
            if (!$this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(context2, reporter, declaration);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker$Regular;", "Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "checkers.js"})
    @SourceDebugExtension(value={"SMAP\nFirJsInheritanceClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsInheritanceClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker$Regular\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,109:1\n35#2:110\n*S KotlinDebug\n*F\n+ 1 FirJsInheritanceClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker$Regular\n*L\n36#1:110\n*E\n"})
    public static final class Regular
    extends FirJsInheritanceClassChecker {
        @NotNull
        public static final Regular INSTANCE = new Regular();

        private Regular() {
            super(MppCheckerKind.Platform, null);
        }

        @Override
        public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            FirMemberDeclaration $this$isExpect$iv = declaration;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(context2, reporter, declaration);
        }
    }
}

