/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.FileScopeFactory;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProviderKt;
import org.jetbrains.kotlin.resolve.lazy.FileScopes;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/lazy/FileScopeProviderImpl;", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopeProvider;", "fileScopeFactory", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopeFactory;", "bindingTrace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "<init>", "(Lorg/jetbrains/kotlin/resolve/lazy/FileScopeFactory;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "cache", "Lorg/jetbrains/kotlin/storage/MemoizedFunctionToNotNull;", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopes;", "getFileScopes", "file", "frontend"})
public final class FileScopeProviderImpl
implements FileScopeProvider {
    @NotNull
    private final FileScopeFactory fileScopeFactory;
    @NotNull
    private final BindingTrace bindingTrace;
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final MemoizedFunctionToNotNull<KtFile, FileScopes> cache;

    public FileScopeProviderImpl(@NotNull FileScopeFactory fileScopeFactory, @NotNull BindingTrace bindingTrace, @NotNull StorageManager storageManager) {
        Intrinsics.checkNotNullParameter((Object)fileScopeFactory, (String)"fileScopeFactory");
        Intrinsics.checkNotNullParameter((Object)bindingTrace, (String)"bindingTrace");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        this.fileScopeFactory = fileScopeFactory;
        this.bindingTrace = bindingTrace;
        this.storageManager = storageManager;
        this.cache = this.storageManager.createMemoizedFunction(arg_0 -> FileScopeProviderImpl.cache$lambda$0(this, arg_0));
    }

    @Override
    @NotNull
    public FileScopes getFileScopes(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (FileScopes)this.cache.invoke(file);
    }

    private static final FileScopes cache$lambda$0(FileScopeProviderImpl this$0, KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object object = (KtFile)file.getOriginalFile();
        if (object == null || (object = FileScopeProviderKt.getFileScopesCustomizer((KtFile)object)) == null || (object = object.createFileScopes(this$0.fileScopeFactory)) == null) {
            object = FileScopeFactory.createScopesForFile$default(this$0.fileScopeFactory, file, null, false, 6, null);
        }
        Object scopes = object;
        BindingContextUtilsKt.recordScope(this$0.bindingTrace, ((FileScopes)scopes).getLexicalScope(), file);
        return scopes;
    }
}

