/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.databend.model;

import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.databend.model.DatabendMetaModel;
import org.jkiss.dbeaver.ext.databend.model.DatabendSQLDialect;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;

public class DatabendDataSource
extends GenericDataSource {
    public DatabendDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container, DatabendMetaModel metaModel) throws DBException {
        super(monitor, container, (GenericMetaModel)metaModel, (SQLDialect)new DatabendSQLDialect());
    }

    protected boolean isPopulateClientAppName() {
        return false;
    }

    @Nullable
    protected Properties getAllConnectionProperties(@NotNull DBRProgressMonitor monitor, JDBCExecutionContext context, String purpose, DBPConnectionConfiguration connectionInfo) throws DBCException {
        Properties properties = super.getAllConnectionProperties(monitor, context, purpose, connectionInfo);
        DBWHandlerConfiguration sslConfig = this.getContainer().getActualConnectionConfiguration().getHandler("databend-ssl");
        if (sslConfig != null && sslConfig.isEnabled()) {
            try {
                this.initSSL(monitor, properties);
            }
            catch (Exception e) {
                throw new DBCException("Error configuring SSL certificates", (Throwable)e);
            }
        }
        return properties;
    }

    private void initSSL(DBRProgressMonitor monitor, Properties properties) throws DBException {
        monitor.subTask("Initialising SSL configuration");
        properties.put("sslmode", "enable");
    }
}

