/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.plan;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.ext.db2.model.plan.DB2PlanNode;
import org.jkiss.dbeaver.ext.db2.model.plan.DB2PlanOperatorArgument;
import org.jkiss.dbeaver.ext.db2.model.plan.DB2PlanOperatorPredicate;
import org.jkiss.dbeaver.ext.db2.model.plan.DB2PlanOperatorType;
import org.jkiss.dbeaver.ext.db2.model.plan.DB2PlanStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanCostNode;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.utils.CommonUtils;

public class DB2PlanOperator
extends DB2PlanNode
implements DBCPlanCostNode {
    private static final String SEL_BASE_SELECT;
    private DB2PlanStatement db2Statement;
    private String planTableSchema;
    private List<DB2PlanOperatorArgument> listArguments;
    private List<DB2PlanOperatorPredicate> listPredicates;
    private String displayName;
    private String nodename;
    private Integer operatorId;
    private DB2PlanOperatorType operatorType;
    private Double totalCost;
    private Double estimatedCardinality = -1.0;

    static {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("SELECT *");
        sb.append(" FROM %s.%s");
        sb.append(" WHERE EXPLAIN_REQUESTER = ?");
        sb.append("   AND EXPLAIN_TIME = ?");
        sb.append("   AND SOURCE_NAME = ?");
        sb.append("   AND SOURCE_SCHEMA = ?");
        sb.append("   AND SOURCE_VERSION = ?");
        sb.append("   AND EXPLAIN_LEVEL = ?");
        sb.append("   AND STMTNO = ?");
        sb.append("   AND SECTNO = ?");
        sb.append("   AND OPERATOR_ID = ?");
        sb.append(" ORDER BY %s");
        sb.append(" WITH UR");
        SEL_BASE_SELECT = sb.toString();
    }

    public DB2PlanOperator(JDBCSession session, JDBCResultSet dbResult, DB2PlanStatement db2Statement, String planTableSchema) throws SQLException {
        this.db2Statement = db2Statement;
        this.planTableSchema = planTableSchema;
        this.operatorId = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"OPERATOR_ID");
        this.operatorType = (DB2PlanOperatorType)CommonUtils.valueOf(DB2PlanOperatorType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OPERATOR_TYPE"));
        this.totalCost = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)"TOTAL_COST");
        this.nodename = DB2PlanOperator.buildName(this.operatorId);
        this.displayName = this.nodename + " - " + String.valueOf((Object)this.operatorType);
        this.loadChildren(session);
    }

    @Override
    public void setEstimatedCardinality(Double estimatedCardinality) {
        this.estimatedCardinality = Math.max(this.estimatedCardinality, estimatedCardinality);
    }

    public String toString() {
        return this.displayName;
    }

    @Override
    public String getNodeName() {
        return this.nodename;
    }

    public String getNodeType() {
        return CommonUtils.toString((Object)((Object)this.operatorType));
    }

    public String getNodeDescription() {
        return null;
    }

    public static String buildName(Integer operatorId) {
        return String.valueOf(operatorId);
    }

    @Property(viewable=true, order=1)
    public DB2PlanOperatorType getOperatorType() {
        return this.operatorType;
    }

    @Property(viewable=true, order=2)
    public Integer getOperatorId() {
        return this.operatorId;
    }

    @Property(viewable=true, order=3)
    public String getDisplayName() {
        return "";
    }

    @Property(viewable=true, order=4, format="###,###,###,##0.000")
    public Double getTotalCost() {
        return this.totalCost;
    }

    @Override
    @Property(viewable=true, order=5, format="###,###,###,##0.000")
    public Double getEstimatedCardinality() {
        return this.estimatedCardinality;
    }

    @Property(viewable=false, order=6)
    public List<DB2PlanOperatorArgument> getArguments() {
        return this.listArguments;
    }

    @Property(viewable=false, order=7)
    public List<DB2PlanOperatorPredicate> getPredicates() {
        return this.listPredicates;
    }

    private void loadChildren(JDBCSession session) throws SQLException {
        JDBCResultSet res;
        Object var6_12;
        Throwable throwable;
        JDBCPreparedStatement sqlStmt;
        this.listArguments = new ArrayList<DB2PlanOperatorArgument>();
        Throwable throwable2 = null;
        Object var3_5 = null;
        try {
            sqlStmt = session.prepareStatement(String.format(SEL_BASE_SELECT, this.planTableSchema, "EXPLAIN_ARGUMENT", "ARGUMENT_TYPE"));
            try {
                this.setQueryParameters(sqlStmt);
                throwable = null;
                var6_12 = null;
                try {
                    res = sqlStmt.executeQuery();
                    try {
                        while (res.next()) {
                            this.listArguments.add(new DB2PlanOperatorArgument(res));
                        }
                    }
                    finally {
                        if (res != null) {
                            res.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            finally {
                if (sqlStmt != null) {
                    sqlStmt.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable2 == null) {
                throwable2 = throwable4;
            } else if (throwable2 != throwable4) {
                throwable2.addSuppressed(throwable4);
            }
            throw throwable2;
        }
        this.listPredicates = new ArrayList<DB2PlanOperatorPredicate>();
        throwable2 = null;
        var3_5 = null;
        try {
            sqlStmt = session.prepareStatement(String.format(SEL_BASE_SELECT, this.planTableSchema, "EXPLAIN_PREDICATE", "PREDICATE_ID"));
            try {
                this.setQueryParameters(sqlStmt);
                throwable = null;
                var6_12 = null;
                try {
                    res = sqlStmt.executeQuery();
                    try {
                        while (res.next()) {
                            this.listPredicates.add(new DB2PlanOperatorPredicate(res, this));
                        }
                    }
                    finally {
                        if (res != null) {
                            res.close();
                        }
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
            }
            finally {
                if (sqlStmt != null) {
                    sqlStmt.close();
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable2 == null) {
                throwable2 = throwable6;
            } else if (throwable2 != throwable6) {
                throwable2.addSuppressed(throwable6);
            }
            throw throwable2;
        }
    }

    private void setQueryParameters(JDBCPreparedStatement sqlStmt) throws SQLException {
        sqlStmt.setString(1, this.db2Statement.getExplainRequester());
        sqlStmt.setTimestamp(2, this.db2Statement.getExplainTime());
        sqlStmt.setString(3, this.db2Statement.getSourceName());
        sqlStmt.setString(4, this.db2Statement.getSourceSchema());
        sqlStmt.setString(5, this.db2Statement.getSourceVersion());
        sqlStmt.setString(6, this.db2Statement.getExplainLevel());
        sqlStmt.setInt(7, this.db2Statement.getStmtNo().intValue());
        sqlStmt.setInt(8, this.db2Statement.getSectNo().intValue());
        sqlStmt.setInt(9, this.operatorId.intValue());
    }

    public Number getNodeCost() {
        return this.totalCost;
    }

    public Number getNodePercent() {
        return null;
    }

    public Number getNodeDuration() {
        return null;
    }

    public Number getNodeRowCount() {
        return null;
    }
}

