/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Ext4DirEntryTail
implements StructConverter {
    private int det_reserved_zero1;
    private short det_rec_len;
    private byte det_reserved_zero2;
    private byte det_reserved_ft;
    private int det_checksum;

    public Ext4DirEntryTail(ByteProvider provider) throws IOException {
        this(new BinaryReader(provider, true));
    }

    public Ext4DirEntryTail(BinaryReader reader) throws IOException {
        this.det_reserved_zero1 = reader.readNextInt();
        this.det_rec_len = reader.readNextShort();
        this.det_reserved_zero2 = reader.readNextByte();
        this.det_reserved_ft = reader.readNextByte();
        this.det_checksum = reader.readNextInt();
    }

    public int getDet_reserved_zero1() {
        return this.det_reserved_zero1;
    }

    public short getDet_rec_len() {
        return this.det_rec_len;
    }

    public byte getDet_reserved_zero2() {
        return this.det_reserved_zero2;
    }

    public byte getDet_reserved_ft() {
        return this.det_reserved_ft;
    }

    public int getDet_checksum() {
        return this.det_checksum;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("ext4_dir_entry_tail", 0);
        structure.add(DWORD, "det_reserved_zero1", null);
        structure.add(WORD, "det_rec_len", null);
        structure.add(BYTE, "det_reserved_zero2", null);
        structure.add(BYTE, "det_reserved_ft", null);
        structure.add(DWORD, "det_checksum", null);
        return structure;
    }
}

