/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.features.bsim.query.protocol.FunctionEntry;
import ghidra.features.bsim.query.protocol.QueryChildren;
import ghidra.features.bsim.query.protocol.QueryResponseRecord;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class ResponseChildren
extends QueryResponseRecord {
    public DescriptionManager manage = new DescriptionManager();
    public List<FunctionDescription> correspond = new ArrayList<FunctionDescription>();
    public QueryChildren qchild;

    public ResponseChildren(QueryChildren qc) {
        super("responsechildren");
        this.qchild = qc;
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append('<').append(this.name).append(">\n");
        this.manage.saveXml(fwrite);
        if (!this.correspond.isEmpty()) {
            fwrite.append("<md5>");
            fwrite.append(this.correspond.get(0).getExecutableRecord().getMd5());
            fwrite.append("</md5>\n");
        }
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        parser.start(new String[]{this.name});
        this.manage.restoreXml(parser, vectorFactory);
        if (!parser.peek().isStart()) {
            return;
        }
        parser.start(new String[]{"md5"});
        String md5string = parser.end().getText();
        ExecutableRecord exe = this.manage.findExecutable(md5string);
        for (FunctionEntry entry : this.qchild.functionKeys) {
            this.correspond.add(this.manage.findFunction(entry.funcName, entry.address, exe));
        }
        parser.end();
    }
}

