/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.pcode.emu.PcodeThread;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import java.util.Collection;

public interface PcodeMachine<T> {
    public SleighLanguage getLanguage();

    public PcodeArithmetic<T> getArithmetic();

    public void setSoftwareInterruptMode(SwiMode var1);

    public SwiMode getSoftwareInterruptMode();

    public PcodeUseropLibrary<T> getUseropLibrary();

    public PcodeUseropLibrary<T> getStubUseropLibrary();

    public PcodeThread<T> newThread();

    public PcodeThread<T> newThread(String var1);

    public PcodeThread<T> getThread(String var1, boolean var2);

    public Collection<? extends PcodeThread<T>> getAllThreads();

    public PcodeExecutorState<T> getSharedState();

    public void setSuspended(boolean var1);

    public boolean isSuspended();

    public PcodeProgram compileSleigh(String var1, String var2);

    public void inject(Address var1, String var2);

    public PcodeProgram getInject(Address var1);

    public void clearInject(Address var1);

    public void clearAllInjects();

    public void addBreakpoint(Address var1, String var2);

    public void addAccessBreakpoint(AddressRange var1, AccessKind var2);

    public void clearAccessBreakpoints();

    public static enum AccessKind {
        R(true, false),
        W(false, true),
        RW(true, true);

        private final boolean trapsRead;
        private final boolean trapsWrite;

        private AccessKind(boolean trapsRead, boolean trapsWrite) {
            this.trapsRead = trapsRead;
            this.trapsWrite = trapsWrite;
        }

        public boolean trapsRead() {
            return this.trapsRead;
        }

        public boolean trapsWrite() {
            return this.trapsWrite;
        }
    }

    public static enum SwiMode {
        ACTIVE,
        IGNORE_ALL,
        IGNORE_STEP;

    }
}

