/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.ActionContext;
import docking.action.MenuData;
import ghidra.app.actions.AbstractFindReferencesToAddressAction;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;

public class FindReferencesToAddressAction
extends AbstractFindReferencesToAddressAction {
    public FindReferencesToAddressAction(PluginTool tool, String owner) {
        super(tool, owner);
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionShowReferences"));
        this.setPopupMenuData(new MenuData(new String[]{"References", "Show References To Address"}));
    }

    protected ProgramLocation getLocation(NavigatableActionContext context) {
        if (!(context instanceof DecompilerActionContext)) {
            return null;
        }
        return context.getLocation();
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DecompilerActionContext)) {
            return false;
        }
        DecompilerActionContext decompilerContext = (DecompilerActionContext)context;
        this.updateMenuName(decompilerContext.getAddress());
        return super.isEnabledForContext(context);
    }

    private void updateMenuName(Address addr) {
        String menuName = "Find References to " + addr.toString();
        MenuData data = this.getPopupMenuData().cloneData();
        data.setMenuPath(new String[]{"References", menuName});
        this.setPopupMenuData(data);
    }
}

