/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database.annotproc;

import java.util.Iterator;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;

class FormatVisitor
implements TypeVisitor<Void, Void> {
    StringBuffer buf = new StringBuffer();

    FormatVisitor() {
    }

    @Override
    public Void visit(TypeMirror t, Void p) {
        switch (t.getKind()) {
            case ARRAY: {
                return this.visitArray((ArrayType)t, p);
            }
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: 
            case VOID: {
                return this.visitPrimitive((PrimitiveType)t, p);
            }
            case DECLARED: {
                return this.visitDeclared((DeclaredType)t, p);
            }
            case ERROR: {
                return this.visitError((ErrorType)t, p);
            }
            case EXECUTABLE: {
                return this.visitExecutable((ExecutableType)t, p);
            }
            case INTERSECTION: {
                return this.visitIntersection((IntersectionType)t, p);
            }
            case NONE: {
                return this.visitNoType((NoType)t, p);
            }
            case NULL: {
                return this.visitNull((NullType)t, p);
            }
            case TYPEVAR: {
                return this.visitTypeVariable((TypeVariable)t, p);
            }
            case UNION: {
                return this.visitUnion((UnionType)t, p);
            }
            case WILDCARD: {
                return this.visitWildcard((WildcardType)t, p);
            }
        }
        return this.visitUnknown(t, p);
    }

    @Override
    public Void visitPrimitive(PrimitiveType t, Void p) {
        this.buf.append(t.toString());
        return null;
    }

    @Override
    public Void visitNull(NullType t, Void p) {
        this.buf.append(t.toString());
        return null;
    }

    @Override
    public Void visitArray(ArrayType t, Void p) {
        this.visit(t.getComponentType());
        this.buf.append("[]");
        return null;
    }

    @Override
    public Void visitDeclared(DeclaredType t, Void p) {
        this.buf.append(t.asElement().toString());
        Iterator<? extends TypeMirror> it = t.getTypeArguments().iterator();
        if (it.hasNext()) {
            this.buf.append("<");
            this.visit(it.next());
            while (it.hasNext()) {
                this.buf.append(", ");
                this.visit(it.next());
            }
            this.buf.append(">");
        }
        return null;
    }

    @Override
    public Void visitError(ErrorType t, Void p) {
        this.buf.append(t.toString());
        return null;
    }

    @Override
    public Void visitTypeVariable(TypeVariable t, Void p) {
        TypeMirror upper;
        this.buf.append(t.toString());
        TypeMirror lower = t.getLowerBound();
        if (lower.getKind() != TypeKind.NULL) {
            this.buf.append(" super ");
            this.visit(lower);
        }
        if (!(upper = t.getUpperBound()).toString().equals("java.lang.Object")) {
            this.buf.append(" extends ");
            this.visit(upper);
        }
        return null;
    }

    @Override
    public Void visitWildcard(WildcardType t, Void p) {
        TypeMirror ext;
        this.buf.append("?");
        TypeMirror sup = t.getSuperBound();
        if (sup != null) {
            this.buf.append(" super ");
            this.visit(sup);
        }
        if ((ext = t.getExtendsBound()) != null) {
            this.buf.append(" extends ");
            this.visit(ext);
        }
        return null;
    }

    @Override
    public Void visitExecutable(ExecutableType t, Void p) {
        this.buf.append(t.toString());
        return null;
    }

    @Override
    public Void visitNoType(NoType t, Void p) {
        this.buf.append(t.toString());
        return null;
    }

    @Override
    public Void visitUnknown(TypeMirror t, Void p) {
        this.buf.append(t.toString());
        return null;
    }

    @Override
    public Void visitUnion(UnionType t, Void p) {
        Iterator<? extends TypeMirror> it = t.getAlternatives().iterator();
        if (it.hasNext()) {
            this.visit(it.next());
            while (it.hasNext()) {
                this.buf.append(" | ");
                this.visit(it.next());
            }
        }
        return null;
    }

    @Override
    public Void visitIntersection(IntersectionType t, Void p) {
        Iterator<? extends TypeMirror> it = t.getBounds().iterator();
        if (it.hasNext()) {
            this.visit(it.next());
            while (it.hasNext()) {
                this.buf.append(" & ");
                this.visit(it.next());
            }
        }
        return null;
    }
}

