/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.programtree;

import ghidra.program.model.listing.Group;
import ghidra.util.Msg;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class GroupTransferable
implements Transferable {
    public static DataFlavor localGroupFlavor = GroupTransferable.createLocalGroupFlavor();
    private Group group;
    private String name;
    private static DataFlavor[] flavors = new DataFlavor[]{localGroupFlavor, DataFlavor.stringFlavor};
    private static List<DataFlavor> flavorList = Arrays.asList(flavors);

    private static DataFlavor createLocalGroupFlavor() {
        try {
            return new DataFlavor("application/x-java-jvm-local-objectref; class=" + Group.class.getName(), "Local Group");
        }
        catch (Exception e) {
            Msg.showError(GroupTransferable.class, null, null, null, (Throwable)e);
            return null;
        }
    }

    public GroupTransferable(Group g) {
        this.group = g;
    }

    public GroupTransferable(String name) {
        this.name = name;
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor f) {
        return flavorList.contains(f);
    }

    @Override
    public synchronized Object getTransferData(DataFlavor f) throws UnsupportedFlavorException, IOException {
        if (f.equals(localGroupFlavor)) {
            return this.group;
        }
        if (f.equals(DataFlavor.stringFlavor)) {
            return this.name;
        }
        throw new UnsupportedFlavorException(f);
    }

    public String toString() {
        return "GroupTransferable";
    }
}

