/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.vscode;

import ghidra.framework.OperatingSystem;
import ghidra.framework.main.ApplicationLevelOnlyPlugin;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.util.HelpLocation;
import java.io.File;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Visual Studio Code Integration Options", description="Options for Visual Studio Code Integration")
public class VSCodeIntegrationOptionsPlugin
extends Plugin
implements ApplicationLevelOnlyPlugin {
    public static final String PLUGIN_OPTIONS_NAME = "Visual Studio Code Integration";
    public static final String VSCODE_EXE_PATH_OPTION = "Visual Studio Code Executable Path";
    private static final String VSCODE_EXE_PATH_DESC = "Path to Visual Studio Code executable";
    private static final File VSCODE_EXE_PATH_DEFAULT = VSCodeIntegrationOptionsPlugin.getDefaultVSCodeExecutable();

    public VSCodeIntegrationOptionsPlugin(PluginTool tool) {
        super(tool);
    }

    public void init() {
        super.init();
        ToolOptions options = this.tool.getOptions(PLUGIN_OPTIONS_NAME);
        options.registerOption(VSCODE_EXE_PATH_OPTION, OptionType.FILE_TYPE, (Object)VSCODE_EXE_PATH_DEFAULT, null, VSCODE_EXE_PATH_DESC);
        options.setOptionsHelpLocation(new HelpLocation("VSCodeIntegration", "VSCodeIntegrationOptions"));
    }

    private static File getDefaultVSCodeExecutable() {
        return switch (OperatingSystem.CURRENT_OPERATING_SYSTEM) {
            case OperatingSystem.WINDOWS -> {
                File local = new File(System.getenv("LOCALAPPDATA"), "Programs/Microsoft VS Code/bin/code.cmd");
                File admin = new File(System.getenv("PROGRAMFILES"), "Microsoft VS Code/bin/code.cmd");
                if (admin.exists()) {
                    yield admin;
                }
                yield local;
            }
            case OperatingSystem.MAC_OS_X -> new File("/Applications/Visual Studio Code.app/Contents/MacOS/Electron");
            case OperatingSystem.LINUX -> new File("/usr/bin/code");
            default -> null;
        };
    }
}

