/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.threadcommand;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.threadcommand.ThreadState;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ThreadStateARM_64
extends ThreadState {
    public static final int ARM64_THREAD_STATE = 6;
    public long x0;
    public long x1;
    public long x2;
    public long x3;
    public long x4;
    public long x5;
    public long x6;
    public long x7;
    public long x8;
    public long x9;
    public long x10;
    public long x11;
    public long x12;
    public long x13;
    public long x14;
    public long x15;
    public long x16;
    public long x17;
    public long x18;
    public long x19;
    public long x20;
    public long x21;
    public long x22;
    public long x23;
    public long x24;
    public long x25;
    public long x26;
    public long x27;
    public long x28;
    public long fp;
    public long lr;
    public long sp;
    public long pc;
    public int cpsr;
    public int pad;

    ThreadStateARM_64(BinaryReader reader) throws IOException {
        this.x0 = reader.readNextLong();
        this.x1 = reader.readNextLong();
        this.x2 = reader.readNextLong();
        this.x3 = reader.readNextLong();
        this.x4 = reader.readNextLong();
        this.x5 = reader.readNextLong();
        this.x6 = reader.readNextLong();
        this.x7 = reader.readNextLong();
        this.x8 = reader.readNextLong();
        this.x9 = reader.readNextLong();
        this.x10 = reader.readNextLong();
        this.x11 = reader.readNextLong();
        this.x12 = reader.readNextLong();
        this.x13 = reader.readNextLong();
        this.x14 = reader.readNextLong();
        this.x15 = reader.readNextLong();
        this.x16 = reader.readNextLong();
        this.x17 = reader.readNextLong();
        this.x18 = reader.readNextLong();
        this.x19 = reader.readNextLong();
        this.x20 = reader.readNextLong();
        this.x21 = reader.readNextLong();
        this.x22 = reader.readNextLong();
        this.x23 = reader.readNextLong();
        this.x24 = reader.readNextLong();
        this.x25 = reader.readNextLong();
        this.x26 = reader.readNextLong();
        this.x27 = reader.readNextLong();
        this.x28 = reader.readNextLong();
        this.fp = reader.readNextLong();
        this.lr = reader.readNextLong();
        this.sp = reader.readNextLong();
        this.pc = reader.readNextLong();
        this.cpsr = reader.readNextInt();
        this.pad = reader.readNextInt();
    }

    @Override
    public long getInstructionPointer() {
        return this.pc;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("ARM64_THREAD_STATE", 0);
        for (int i = 0; i <= 28; ++i) {
            struct.add(QWORD, "x" + i, null);
        }
        struct.add(QWORD, "fp", null);
        struct.add(QWORD, "lr", null);
        struct.add(QWORD, "sp", null);
        struct.add(QWORD, "pc", null);
        struct.add(DWORD, "cpsr", null);
        struct.add(DWORD, "pad", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

