/*
 * Decompiled with CFR 0.152.
 */
package functioncalls.graph;

import functioncalls.graph.FcgDirection;
import functioncalls.graph.FcgEdge;
import functioncalls.graph.FcgLevel;
import functioncalls.graph.FcgVertex;
import ghidra.graph.graphs.FilteringVisualGraph;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.layout.VisualGraphLayout;
import ghidra.program.model.listing.Function;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.map.LazyMap;

public class FunctionCallGraph
extends FilteringVisualGraph<FcgVertex, FcgEdge> {
    private VisualGraphLayout<FcgVertex, FcgEdge> layout;
    private FcgVertex source;
    private Map<Function, FcgVertex> verticesByFunction = new HashMap<Function, FcgVertex>();
    private Comparator<FcgVertex> vertexComparator = (v1, v2) -> v1.getAddress().compareTo((Object)v2.getAddress());
    private Map<FcgLevel, Set<FcgVertex>> verticesByLevel = LazyMap.lazyMap(new HashMap(), () -> new TreeSet<FcgVertex>(this.vertexComparator));

    public void setSource(FcgVertex source) {
        if (this.source != null) {
            throw new IllegalStateException("Cannot change graph source once it has been created");
        }
        this.source = source;
        this.addVertex((VisualVertex)source);
    }

    public FcgVertex getSource() {
        return this.source;
    }

    public FcgVertex getVertex(Function f) {
        return this.verticesByFunction.get(f);
    }

    public boolean containsFunction(Function f) {
        return this.verticesByFunction.containsKey(f);
    }

    public Iterable<FcgVertex> getVerticesByLevel(FcgLevel level) {
        return IterableUtils.unmodifiableIterable((Iterable)this.verticesByLevel.get(level));
    }

    public FcgLevel getLargestLevel(FcgDirection direction) {
        FcgLevel greatest = new FcgLevel(1, direction);
        Set<FcgLevel> keys = this.verticesByLevel.keySet();
        for (FcgLevel level : keys) {
            if (level.getDirection() != direction || level.getRow() <= greatest.getRow()) continue;
            greatest = level;
        }
        return greatest;
    }

    public VisualGraphLayout<FcgVertex, FcgEdge> getLayout() {
        return this.layout;
    }

    public FunctionCallGraph copy() {
        FunctionCallGraph newGraph = new FunctionCallGraph();
        for (FcgVertex v : this.vertices.keySet()) {
            newGraph.addVertex((VisualVertex)v);
        }
        for (FcgEdge e : this.edges.keySet()) {
            newGraph.addEdge((VisualEdge)e);
        }
        return newGraph;
    }

    public void setLayout(VisualGraphLayout<FcgVertex, FcgEdge> layout) {
        this.layout = layout;
    }

    protected void verticesAdded(Collection<FcgVertex> added) {
        for (FcgVertex v : added) {
            Function f = v.getFunction();
            this.verticesByFunction.put(f, v);
            this.verticesByLevel.get(v.getLevel()).add(v);
        }
        super.verticesAdded(added);
    }

    protected void verticesRemoved(Collection<FcgVertex> removed) {
        for (FcgVertex v : removed) {
            Function f = v.getFunction();
            this.verticesByFunction.remove(f);
            this.verticesByLevel.get(v.getLevel()).remove((Object)v);
        }
        super.verticesRemoved(removed);
    }
}

