/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.breakpoint;

import docking.DialogComponentProvider;
import generic.theme.GThemeDefaults;
import generic.theme.Gui;
import ghidra.framework.plugintool.PluginTool;
import ghidra.pcode.exec.SleighUtils;
import ghidra.util.HTMLUtilities;
import ghidra.util.MessageType;
import ghidra.util.Swing;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public abstract class AbstractDebuggerSleighInputDialog
extends DialogComponentProvider {
    protected static final Color COLOR_ERROR = GThemeDefaults.Colors.ERROR;
    protected static final AttributeSet RED_UNDERLINE;
    protected final JPanel panel = new JPanel(new BorderLayout());
    protected final JLabel label;
    protected final StyledDocument docInput;
    protected final JTextPane textInput;
    private JScrollPane spInput;
    protected boolean isValid = false;

    protected AbstractDebuggerSleighInputDialog(String title, String prompt) {
        super(title, true, true, true, false);
        this.panel.setBorder(new EmptyBorder(16, 16, 16, 16));
        this.label = new JLabel(prompt);
        this.label.getMaximumSize().width = 400;
        this.panel.add((Component)this.label, "North");
        this.docInput = new DefaultStyledDocument();
        this.textInput = new SleighTextPane(this.docInput);
        this.spInput = new JScrollPane(this.textInput);
        this.spInput.getMaximumSize().height = 300;
        this.panel.add(this.spInput);
        this.addWorkPanel(this.panel);
        this.addOKButton();
        this.addCancelButton();
    }

    public String prompt(PluginTool tool, String defaultInput) {
        this.setStatusText("");
        this.textInput.setText(defaultInput);
        this.validateAndMarkup();
        Swing.runLater(() -> this.repack());
        tool.showDialog((DialogComponentProvider)this);
        if (this.isValid) {
            return this.getInput();
        }
        return null;
    }

    public String getInput() {
        return this.textInput.getText();
    }

    protected abstract void validate();

    protected void clearAttributes() {
        this.docInput.setCharacterAttributes(0, this.docInput.getLength() + 1, SimpleAttributeSet.EMPTY, true);
    }

    protected void addErrorAttribute(int start, int stop) {
        int length = stop - start + 1;
        this.docInput.setCharacterAttributes(start, length, RED_UNDERLINE, true);
    }

    protected void validateAndMarkup() {
        this.isValid = false;
        this.clearAttributes();
        try {
            this.validate();
            this.isValid = true;
        }
        catch (SleighUtils.SleighParseError e) {
            this.setStatusText("<html><pre>" + HTMLUtilities.escapeHTML((String)e.getMessage()) + "</pre>", MessageType.ERROR, false);
            Swing.runLater(() -> {
                if (this.spInput.getPreferredSize().height > this.spInput.getSize().height) {
                    this.repack();
                }
            });
            for (SleighUtils.SleighParseErrorEntry error : e.getErrors()) {
                this.addErrorAttribute(error.start(), error.stop());
            }
        }
    }

    protected void okCallback() {
        this.validateAndMarkup();
        if (this.isValid) {
            this.close();
        }
    }

    protected void cancelCallback() {
        this.isValid = false;
        this.close();
    }

    static {
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setForeground(attributes, COLOR_ERROR);
        StyleConstants.setUnderline(attributes, true);
        RED_UNDERLINE = attributes;
    }

    static class SleighTextPane
    extends JTextPane {
        public SleighTextPane(StyledDocument document) {
            super(document);
            Gui.registerFont((Component)this, (String)"font.debugger.sleigh");
        }
    }
}

