/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.analysis.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.StemmerOverrideFilter;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractTokenFilterFactory;
import org.opensearch.index.analysis.Analysis;
import org.opensearch.index.analysis.MappingRule;

public class StemmerOverrideTokenFilterFactory
extends AbstractTokenFilterFactory {
    private static final String MAPPING_SEPARATOR = "=>";
    private final StemmerOverrideFilter.StemmerOverrideMap overrideMap;

    StemmerOverrideTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) throws IOException {
        super(indexSettings, name, settings);
        List rules = Analysis.parseWordList((Environment)env, (Settings)settings, (String)"rules", this::parse);
        if (rules == null) {
            throw new IllegalArgumentException("stemmer override filter requires either `rules` or `rules_path` to be configured");
        }
        StemmerOverrideFilter.Builder builder = new StemmerOverrideFilter.Builder(false);
        for (MappingRule rule : rules) {
            for (String key : (List)rule.getLeft()) {
                builder.add((CharSequence)key, (CharSequence)rule.getRight());
            }
        }
        this.overrideMap = builder.build();
    }

    public TokenStream create(TokenStream tokenStream) {
        return new StemmerOverrideFilter(tokenStream, this.overrideMap);
    }

    private MappingRule<List<String>, String> parse(String rule) {
        String[] sides = rule.split(MAPPING_SEPARATOR, -1);
        if (sides.length != 2) {
            throw new RuntimeException("Invalid keyword override rule: " + rule);
        }
        String[] keys = sides[0].split(",", -1);
        String override = sides[1].trim();
        if (override.isEmpty() || override.indexOf(44) != -1) {
            throw new RuntimeException("Invalid keyword override rule: " + rule);
        }
        ArrayList<String> trimmedKeys = new ArrayList<String>();
        for (String key : keys) {
            String trimmedKey = key.trim();
            if (trimmedKey.isEmpty()) {
                throw new RuntimeException("Invalid keyword override rule: " + rule);
            }
            trimmedKeys.add(trimmedKey);
        }
        return new MappingRule(trimmedKeys, (Object)override);
    }
}

