/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.toml;

import org.apache.tuweni.toml.TomlParseError;
import org.apache.tuweni.toml.TomlPosition;
import org.apache.tuweni.toml.internal.TomlParser;
import org.apache.tuweni.toml.internal.TomlParserBaseVisitor;

final class QuotedStringVisitor
extends TomlParserBaseVisitor<StringBuilder> {
    private final StringBuilder builder = new StringBuilder();

    QuotedStringVisitor() {
    }

    @Override
    public StringBuilder visitLiteralBody(TomlParser.LiteralBodyContext ctx) {
        return this.builder.append(ctx.getText());
    }

    @Override
    public StringBuilder visitMlLiteralBody(TomlParser.MlLiteralBodyContext ctx) {
        return this.builder.append(ctx.getText());
    }

    @Override
    public StringBuilder visitBasicUnescaped(TomlParser.BasicUnescapedContext ctx) {
        return this.builder.append(ctx.getText());
    }

    @Override
    public StringBuilder visitMlBasicUnescaped(TomlParser.MlBasicUnescapedContext ctx) {
        return this.builder.append(ctx.getText());
    }

    @Override
    public StringBuilder visitEscaped(TomlParser.EscapedContext ctx) {
        String text = ctx.getText();
        if (text.isEmpty()) {
            return this.builder;
        }
        assert (text.charAt(0) == '\\');
        if (text.length() == 1) {
            return this.builder.append('\\');
        }
        switch (text.charAt(1)) {
            case '\"': {
                return this.builder.append('\"');
            }
            case '\\': {
                return this.builder.append('\\');
            }
            case 'b': {
                return this.builder.append('\b');
            }
            case 'f': {
                return this.builder.append('\f');
            }
            case 'n': {
                return this.builder.append('\n');
            }
            case 'r': {
                return this.builder.append('\r');
            }
            case 't': {
                return this.builder.append('\t');
            }
            case 'u': {
                assert (text.length() == 6);
                return this.builder.append(this.convertUnicodeEscape(text.substring(2), ctx));
            }
            case 'U': {
                assert (text.length() == 10);
                return this.builder.append(this.convertUnicodeEscape(text.substring(2), ctx));
            }
        }
        throw new TomlParseError("Invalid escape sequence '" + text + "'", new TomlPosition(ctx));
    }

    private char[] convertUnicodeEscape(String hexChars, TomlParser.EscapedContext ctx) {
        try {
            return Character.toChars(Integer.parseInt(hexChars, 16));
        }
        catch (IllegalArgumentException e) {
            throw new TomlParseError("Invalid unicode escape sequence", new TomlPosition(ctx));
        }
    }

    @Override
    protected StringBuilder aggregateResult(StringBuilder aggregate, StringBuilder nextResult) {
        return aggregate == null ? null : nextResult;
    }

    @Override
    protected StringBuilder defaultResult() {
        return this.builder;
    }
}

