/*
 * Decompiled with CFR 0.152.
 */
package hughai.controllers.level1;

import com.springrts.ai.oo.clb.Unit;
import com.springrts.ai.oo.clb.UnitDef;
import hughai.GameAdapter;
import hughai.PlayerObjects;
import hughai.controllers.level2.TankController2;
import hughai.unitdata.BuildTable;
import hughai.unitdata.UnitController;
import hughai.utils.Config;
import hughai.utils.LogFile;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class Offense {
    PlayerObjects playerObjects;
    LogFile logfile;
    Config config;
    BuildTable buildTable;
    UnitController unitController;
    Collection<UnitDef> managedUnitTypes = new HashSet<UnitDef>();
    Collection<Unit> managedunits = new HashSet<Unit>();
    TankController2 tankcontroller;

    public Offense(PlayerObjects playerObjects) {
        this.playerObjects = playerObjects;
        this.logfile = playerObjects.getLogFile();
        this.config = playerObjects.getConfig();
        this.buildTable = playerObjects.getBuildTable();
        this.unitController = playerObjects.getUnitController();
    }

    public void Activate() {
        this.playerObjects.getCSAI().registerGameListener(new GameListener());
        this.unitController.registerListener(new UnitListener());
        List<String> list = this.config.getOffensiveunitnames();
        this.managedUnitTypes.clear();
        for (String string : list) {
            UnitDef unitDef = this.buildTable.getUnitDefByName(string);
            this.managedUnitTypes.add(unitDef);
            this.logfile.WriteLine("Allowed unit type for " + this.getClass().getSimpleName() + " " + unitDef.getHumanName());
        }
        UnitDef unitDef = this.buildTable.getUnitDefByName(this.config.getTypicallevel1tankunitdefname());
        this.tankcontroller = new TankController2(this.playerObjects, unitDef);
        this.tankcontroller.Activate();
    }

    void Reappraise(int n) {
        if (n % 150 == 0) {
            // empty if block
        }
    }

    class UnitListener
    extends UnitController.UnitAdapter {
        UnitListener() {
        }

        @Override
        public void UnitAdded(Unit unit) {
            UnitDef unitDef = unit.getDef();
            if (Offense.this.managedUnitTypes.contains(unitDef)) {
                Offense.this.logfile.WriteLine("New offensive unit: " + unit.getUnitId() + " " + unit.getDef().getHumanName());
                Offense.this.managedunits.add(unit);
                Offense.this.tankcontroller.AssignUnits(Arrays.asList(unit));
            }
        }

        @Override
        public void UnitRemoved(Unit unit) {
            UnitDef unitDef = unit.getDef();
            if (Offense.this.managedUnitTypes.contains(unitDef)) {
                Offense.this.managedunits.remove(unit);
                Offense.this.tankcontroller.RevokeUnits(Arrays.asList(unit));
            }
        }
    }

    class GameListener
    extends GameAdapter {
        GameListener() {
        }

        @Override
        public void Tick(int n) {
            Offense.this.Reappraise(n);
        }
    }
}

