/*
 * Decompiled with CFR 0.152.
 */
package hughai.utils;

import com.springrts.ai.oo.AIFloat3;
import com.springrts.ai.oo.clb.Unit;
import com.springrts.ai.oo.clb.UnitDef;
import hughai.PlayerObjects;
import hughai.utils.Formatting;
import hughai.utils.XmlHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReflectionHelper {
    PlayerObjects playerObjects;
    int indent = 0;

    public ReflectionHelper(PlayerObjects playerObjects) {
        this.playerObjects = playerObjects;
    }

    public void loadObjectFromFile(String string, Object object) {
        try {
            Document document = XmlHelper.OpenDom(string);
            this.loadObjectFromElement(document.getDocumentElement(), object);
        }
        catch (Exception exception) {
            this.playerObjects.getLogFile().WriteLine(Formatting.exceptionToStackTrace(exception));
            throw new RuntimeException(exception);
        }
    }

    public void loadObjectFromElement(Element element, Object object) throws Exception {
        String string = object.getClass().getSimpleName();
        this.writeDebugLine("loadObjectFromElement " + string + " {");
        this.indent += 3;
        for (Field field : object.getClass().getDeclaredFields()) {
            Exclude exclude = field.getAnnotation(Exclude.class);
            if (exclude != null) continue;
            this.writeDebugLine("reading " + string + " property " + field.getName());
            for (Annotation annotation : field.getAnnotations()) {
                this.writeDebugLine("- annotation: " + annotation);
            }
            Object object2 = this.elementToFieldValue(true, field.getName(), field.getType(), field.getAnnotations(), element);
            if (object2 == null) continue;
            field.set(object, object2);
        }
        this.indent -= 3;
        this.writeDebugLine("} // loadObjectFromElement " + string);
    }

    void validate() {
    }

    public void saveObjectToFile(String string, Object object) {
        try {
            Document document = XmlHelper.CreateDom();
            Element element = document.getDocumentElement();
            this.writeDebugLine("Saving " + object.getClass().getSimpleName() + " to " + string);
            this.saveObjectToElement(element, object);
            XmlHelper.SaveDom(document, string);
        }
        catch (Exception exception) {
            this.playerObjects.getLogFile().WriteLine(Formatting.exceptionToStackTrace(exception));
            throw new RuntimeException(exception);
        }
    }

    String padLeft(String string, String string2, int n) {
        while (string.length() < n) {
            string = string2 + string;
        }
        return string;
    }

    void writeDebugLine(String string) {
    }

    void debug(Object object) {
        this.playerObjects.getLogFile().WriteLine("" + this.getClass().getSimpleName() + ": " + object);
    }

    public void saveObjectToElement(Element element, Object object) throws Exception {
        if (object == null) {
            element.setAttribute("null", "null");
            return;
        }
        String string = object.getClass().getSimpleName();
        this.writeDebugLine("SaveObjectToelement " + string + " {");
        this.indent += 3;
        for (Field field : object.getClass().getDeclaredFields()) {
            Exclude exclude = field.getAnnotation(Exclude.class);
            if (exclude != null) continue;
            this.writeDebugLine("writing " + string + " property " + field.getName());
            Object object2 = field.get(object);
            this.writeDebugLine("SaveObjectToelement " + field.getName() + " annotations: " + field.getAnnotations().length);
            this.addFieldValueToElement(true, field.getName(), element, field.getType(), field.getAnnotations(), object2);
        }
        this.indent -= 3;
        this.writeDebugLine("} // SaveObjectToelement " + string);
    }

    String primitiveToString(Class<?> clazz, Object object) {
        if (clazz == String.class) {
            return (String)object;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            if (((Boolean)object).booleanValue()) {
                return "yes";
            }
            return "no";
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return "" + object;
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return "" + object;
        }
        throw new RuntimeException("Config.primitiveToString: unknown field class: " + clazz.getName());
    }

    /*
     * WARNING - void declaration
     */
    void addFieldValueToElement(boolean bl, String string, Element element, Class<?> clazz, Annotation[] annotationArray, Object object) throws Exception {
        void var10_17;
        this.writeDebugLine("addFieldValueToElement " + object + " " + clazz.getSimpleName());
        if (clazz == String.class) {
            String string2 = this.primitiveToString(clazz, object);
            this.writeDebugLine("setting attribute " + string + " to " + string2);
            element.setAttribute(string, string2);
            return;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            element.setAttribute(string, this.primitiveToString(clazz, object));
            return;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            element.setAttribute(string, this.primitiveToString(clazz, object));
            return;
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            element.setAttribute(string, this.primitiveToString(clazz, object));
            return;
        }
        if (List.class.isAssignableFrom(clazz)) {
            List list = (List)object;
            ListTypeInfo listTypeInfo = null;
            CustomClass customClass = null;
            for (Annotation annotation : annotationArray) {
                if (ListTypeInfo.class.isAssignableFrom(annotation.getClass())) {
                    listTypeInfo = (ListTypeInfo)annotation;
                }
                if (!CustomClass.class.isAssignableFrom(annotation.getClass())) continue;
                customClass = (CustomClass)annotation;
            }
            if (listTypeInfo == null) {
                throw new RuntimeException("Reflectionhelper: encountered ArrayList without a ListTypeInfo annotation.");
            }
            this.writeDebugLine("List type: " + listTypeInfo.value().getSimpleName());
            Class<?> clazz2 = listTypeInfo.value();
            Element element2 = XmlHelper.AddChild(element, "list");
            element2.setAttribute("fieldname", string);
            if (object == null) {
                element2.setAttribute("null", "null");
                return;
            }
            for (Annotation annotation : list) {
                Element element3 = XmlHelper.AddChild(element2, "listitem");
                ArrayList<CustomClass> arrayList = new ArrayList<CustomClass>();
                if (customClass != null) {
                    arrayList.add(customClass);
                }
                this.addFieldValueToElement(false, "value", element3, clazz2, arrayList.toArray(new Annotation[0]), annotation);
            }
            return;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            throw new RuntimeException("ReflectionHelper: maps not handled yet.");
        }
        if (Unit.class.isAssignableFrom(clazz)) {
            throw new RuntimeException("ReflectionHelper: Units deliberately not handled ;-) .");
        }
        if (UnitDef.class.isAssignableFrom(clazz)) {
            throw new RuntimeException("ReflectionHelper: UnitDefs deliberately not handled ;-) .");
        }
        if (AIFloat3.class.isAssignableFrom(clazz)) {
            throw new RuntimeException("ReflectionHelper: AIFloat3s deliberately not handled ;-) .");
        }
        boolean bl2 = false;
        Annotation[] annotationArray2 = annotationArray;
        int n = annotationArray2.length;
        boolean bl3 = false;
        while (var10_17 < n) {
            Annotation annotation = annotationArray2[var10_17];
            if (CustomClass.class.isAssignableFrom(annotation.getClass())) {
                bl2 = true;
            }
            ++var10_17;
        }
        if (bl2) {
            if (bl) {
                element = XmlHelper.AddChild(element, "object");
                element.setAttribute("fieldname", string);
            }
            this.saveObjectToElement(element, object);
            return;
        }
        throw new RuntimeException("addFieldValueToElement: unknown field class: " + clazz.getName());
    }

    /*
     * WARNING - void declaration
     */
    Object elementToFieldValue(boolean bl, String string, Class<?> clazz, Annotation[] annotationArray, Element element) {
        try {
            void var9_16;
            if (clazz == String.class) {
                if (!element.hasAttribute(string)) {
                    return null;
                }
                return this.stringTofieldValue(clazz, element.getAttribute(string));
            }
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                if (!element.hasAttribute(string)) {
                    return null;
                }
                return this.stringTofieldValue(clazz, element.getAttribute(string));
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                if (!element.hasAttribute(string)) {
                    return null;
                }
                return this.stringTofieldValue(clazz, element.getAttribute(string));
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                if (!element.hasAttribute(string)) {
                    return null;
                }
                return this.stringTofieldValue(clazz, element.getAttribute(string));
            }
            if (List.class.isAssignableFrom(clazz)) {
                Element element2 = XmlHelper.SelectSingleElement(element, "list[@fieldname='" + string + "']");
                if (element2 == null) {
                    return null;
                }
                if (element2.getAttribute("null").equals("null")) {
                    this.writeDebugLine("ReflectionHelper.elementToFieldValue object field is null.");
                    return null;
                }
                ListTypeInfo listTypeInfo = null;
                CustomClass customClass = null;
                for (Annotation annotation : annotationArray) {
                    if (ListTypeInfo.class.isAssignableFrom(annotation.getClass())) {
                        listTypeInfo = (ListTypeInfo)annotation;
                    }
                    if (!CustomClass.class.isAssignableFrom(annotation.getClass())) continue;
                    customClass = (CustomClass)annotation;
                }
                if (listTypeInfo == null) {
                    throw new RuntimeException("ReflectionHelper: error: arraylist used without ListTypeInfo annotation type.");
                }
                Class<?> clazz2 = listTypeInfo.value();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (Element element3 : XmlHelper.SelectElements(element2, "listitem")) {
                    ArrayList<CustomClass> arrayList2 = new ArrayList<CustomClass>();
                    if (customClass != null) {
                        arrayList2.add(customClass);
                    }
                    Object object = this.elementToFieldValue(false, "value", clazz2, arrayList2.toArray(new Annotation[0]), element3);
                    arrayList.add(object);
                    this.writeDebugLine(" list element " + element3.getAttribute("value"));
                }
                return arrayList;
            }
            if (Map.class.isAssignableFrom(clazz)) {
                throw new RuntimeException("ReflectionHelper: maps not handled yet.");
            }
            if (Unit.class.isAssignableFrom(clazz)) {
                throw new RuntimeException("ReflectionHelper: Units deliberately not handled ;-) .");
            }
            if (UnitDef.class.isAssignableFrom(clazz)) {
                throw new RuntimeException("ReflectionHelper: UnitDefs deliberately not handled ;-) .");
            }
            if (AIFloat3.class.isAssignableFrom(clazz)) {
                throw new RuntimeException("ReflectionHelper: AIFloat3s deliberately not handled ;-) .");
            }
            boolean bl2 = false;
            Object obj = annotationArray;
            int n = ((Annotation[])obj).length;
            boolean bl3 = false;
            while (var9_16 < n) {
                Annotation annotation = obj[var9_16];
                if (CustomClass.class.isAssignableFrom(annotation.getClass())) {
                    bl2 = true;
                }
                ++var9_16;
            }
            if (bl2) {
                if (bl) {
                    element = XmlHelper.SelectSingleElement(element, "object[@fieldname='" + string + "']");
                }
                if (element.getAttribute("null").equals("null")) {
                    this.writeDebugLine("ReflectionHelper.elementToFieldValue object field is null.");
                    return null;
                }
                this.writeDebugLine("ReflectionHelper.elementToFieldValue making new child object...");
                obj = clazz.newInstance();
                this.writeDebugLine("New child object: " + obj + " " + obj.getClass());
                this.loadObjectFromElement(element, obj);
                return obj;
            }
        }
        catch (Exception exception) {
            this.playerObjects.getLogFile().WriteLine(Formatting.exceptionToStackTrace(exception));
            throw new RuntimeException(exception);
        }
        throw new RuntimeException("elementToFieldValue: unknown field class: " + clazz.getName());
    }

    public Object stringTofieldValue(Class<?> clazz, String string) {
        if (clazz == String.class) {
            return string;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            if ((string = string.toLowerCase()).equals("yes") || string.equals("true")) {
                return true;
            }
            return false;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return Integer.parseInt(string);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return Float.valueOf(Float.parseFloat(string));
        }
        throw new RuntimeException("Config.stringTofieldValue: unknown field class: " + clazz.getName());
    }

    public void deepCopy(Object object, Object object2) {
        this.deepCopy(object, object2, true);
    }

    public void deepCopy(Object object, Object object2, boolean bl) {
        try {
            for (Field field : object.getClass().getDeclaredFields()) {
                Exclude exclude = field.getAnnotation(Exclude.class);
                if (exclude != null) continue;
                Object object3 = field.get(object);
                if (object3 == null) {
                    if (!bl) continue;
                    field.set(object2, null);
                    continue;
                }
                this.debug("copying field " + field.getName());
                field.set(object2, this.deepCopyGeneric(object3));
            }
        }
        catch (Exception exception) {
            this.playerObjects.getLogFile().writeStackTrace(exception);
            throw new RuntimeException(exception);
        }
    }

    Object deepCopyGeneric(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            return objectInputStream.readObject();
        }
        catch (Exception exception) {
            this.playerObjects.getLogFile().writeStackTrace(exception);
            throw new RuntimeException(exception);
        }
    }

    public void deepCopyNonNullOnly(Object object, Object object2) {
        this.deepCopy(object, object2, false);
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Exclude {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface CustomClass {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface MapTypeInfo {
        public Class<?> keyType();

        public Class<?> valueType();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ListTypeInfo {
        public Class<?> value();
    }
}

